//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "GLWektory.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TGLForm(Owner),
        Phi(0.0f), Theta(0.0f),
        PozycjaX(0.0f), PozycjaY(0.0f), PozycjaZ(0.0f)
{
   KolorTla=clBlack;
   debug_mode=false;
   NatezenieSwiatlaOtoczenia=0.5f;
   Obracaj(10.0f,1.0f,0.0f);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   //obroty kontrolowane klawiszami
   glRotatef(Phi, 0.0, 1.0, 0.0); //wokol OY
   glRotatef(Theta, 1.0, 0.0, 0.0); //wokol OX

   //przesuniecia kontrolowane klawiszami
   glTranslatef(PozycjaX,PozycjaY,PozycjaZ);

   glPushMatrix();

   const float x0=1.0;
   const float y0=1.0;
   const float z0=1.0;

   /*
   //rysowanie ostroslupa
   RysujOstroslup(x0,y0,z0);

   //kolejne ostroslupy
   for (int i=0;i<3;i++)
   {
      glRotatef(90.0, 0.0, 1.0, 0.0);
      RysujOstroslup(x0,y0,z0);
   }
   glRotatef(90.0, 0.0, 1.0, 0.0); //dopelnienie pelnego obrotu
   */

   //rysowanie szescianu
   //glColor3ub(0,0,150);
   //RysujSzescian(x0);
   //RysujSzescian_UsrednianieNormalnych(x0);

   const float wsp_odbicia_szklo[4]={1.0,1.0,1.0,1.0};
	const float wsp_odbicia_matowy[4]={0.0,0.0,0.0,1.0};

	glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_szklo);
	glMateriali(GL_FRONT,GL_SHININESS,100);
	//glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SEPARATE_SPECULAR_COLOR); //konieczne, aby tekstury nie psuly

   glColor3ub(0,0,150);
	RysujSzescian(x0);

	//glLightModeli(GL_LIGHT_MODEL_COLOR_CONTROL,GL_SINGLE_COLOR);
	glMaterialfv(GL_FRONT,GL_SPECULAR,wsp_odbicia_matowy);
	glMateriali(GL_FRONT,GL_SHININESS,0);

   glPopMatrix();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujOstroslup(float x0,float y0,float z0) const
{
   const bool kolory=false;

   //Rysowanie trojkata
   glBegin(GL_TRIANGLES);
   //ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
   //(0,0,z) jest mniej wiecej w srodku ekranu

   //tylna
   if(kolory) glColor3ub(255,255,0); //zolty
   glNormal3f(0,0,-1.0); //w glab
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, y0, z0); //gorny

   //podstawa
   if(kolory) glColor3ub(0,255,0); //zielony
   glNormal3f(0,-1.0,0); //do dolu
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni

   //lewa
   if(kolory) glColor3ub(255,0,0); //czerwony
   float punktL1[3]={-x0,-y0,z0};
   float punktL2[3]={0,-y0,2*z0};
   float punktL3[3]={0,y0,z0};
   float normalnaL[3];
   JednostkowyWektorNormalny3fv(punktL1,punktL2,punktL3,normalnaL);
   glNormal3fv(normalnaL);
   glVertex3fv(punktL1); //dolny lewy
   glVertex3fv(punktL2); //dolny przedni
   glVertex3fv(punktL3); //gorny

   //prawa
   if(kolory) glColor3ub(0,0,255); //niebieski
   float punktR1[3]={x0, -y0, z0}; //dolny prawy
   float punktR2[3]={0, -y0, 2*z0}; //dolny przedni
   float punktR3[3]={0, y0, z0}; //gorny
   //odwrocone - aby nawijanie bylo prawidlowe (przy def. trojkata tez zmiana kolejnosci)
   float normalnaR[3];
   JednostkowyWektorNormalny3fv(punktR1,punktR3,punktR2,normalnaR);
   glNormal3fv(normalnaR);
   glVertex3fv(punktR1); //dolny lewy
   glVertex3fv(punktR3); //dolny przedni
   glVertex3fv(punktR2); //gorny

   //koniec rysowania figury
   glEnd();
}

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   //obroty
   if (Shift.Empty())
   {
      if (Key>='0' && Key<='7')
      {
         GLenum swiatlo=GL_LIGHT0;
         switch (Key)
         {
            case '1': swiatlo=GL_LIGHT1; break;
            case '2': swiatlo=GL_LIGHT2; break;
            case '3': swiatlo=GL_LIGHT3; break;
            case '4': swiatlo=GL_LIGHT4; break;
            case '5': swiatlo=GL_LIGHT5; break;
            case '6': swiatlo=GL_LIGHT6; break;
            case '7': swiatlo=GL_LIGHT7; break;
            default: swiatlo=GL_LIGHT0;
         }
         if (glIsEnabled(swiatlo)) glDisable(swiatlo);
         else glEnable(swiatlo);
      }

      switch (Key)
      {
         case VK_LEFT:   Phi-=3; break;
         case VK_RIGHT:  Phi+=3; break;
         case VK_UP :    Theta-=3; break;
         case VK_DOWN:   Theta+=3; break;

         case 'q':
         case 'Q':
            Timer1->Enabled=!Timer1->Enabled;
            break;

         case VK_OEM_MINUS:
            NatezenieSwiatlaOtoczenia-=0.01;
            break;
         case VK_OEM_PLUS:
         case '=':
            NatezenieSwiatlaOtoczenia+=0.01;
            break;
      }
   }

   //przesuniecia w pionie i poziomie
   if (Shift.Contains(ssCtrl))
   {
      switch (Key)
      {
            case VK_LEFT:  PozycjaX-=0.1; break;
            case VK_RIGHT: PozycjaX+=0.1; break;
            case VK_UP:    PozycjaY+=0.1; break;
            case VK_DOWN:  PozycjaY-=0.1; break;
      }
   }

   //przesuniecia w poziomie i przod-tyl
   if (Shift.Contains(ssShift))
   {
      switch (Key)
      {
         case VK_LEFT:  PozycjaX-=0.1; break;
         case VK_RIGHT: PozycjaX+=0.1; break;
         case VK_UP:    PozycjaZ-=0.1; break;
         case VK_DOWN:  PozycjaZ+=0.1; break;
      }
   }

   GL_RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   Phi+=1;
   Theta+=0.1;
   GL_RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RysujSzescian(float krawedz) const
{
	const float a=krawedz;

	glBegin(GL_QUADS);
	//tylnia
   glNormal3f(0,0,-1); //wektory normalne skierowane na zewnatrz
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,-a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,-a);
	//przednia
   glNormal3f(0,0,1);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,a);

	//prawa
   glNormal3f(1,0,0);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(a,-a,-a);
	//lewa
   glNormal3f(-1,0,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(-a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);

	//gorna
   glNormal3f(0,1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,a,-a);
	//dolna
   glNormal3f(0,-1,0);
	glTexCoord2f(1.0f, 1.0f); glVertex3f(-a,-a,a);
	glTexCoord2f(1.0f, 0.0f); glVertex3f(a,-a,a);
	glTexCoord2f(0.0f, 0.0f); glVertex3f(a,-a,-a);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-a,-a,-a);
	//

	glEnd();
}

void __fastcall TForm1::RysujSzescian_UsrednianieNormalnych(float krawedz) const
{
	const float a=krawedz;

	glBegin(GL_QUADS);
	//tylnia
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	//przednia
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);

	//prawa
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	//lewa
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);

	//gorna
	glNormal3f(-1,1,1); glVertex3f(-a,a,a);
	glNormal3f(1,1,1); glVertex3f(a,a,a);
	glNormal3f(1,1,-1); glVertex3f(a,a,-a);
	glNormal3f(-1,1,-1); glVertex3f(-a,a,-a);
	//dolna
	glNormal3f(-1,-1,1); glVertex3f(-a,-a,a);
	glNormal3f(1,-1,1); glVertex3f(a,-a,a);
	glNormal3f(1,-1,-1); glVertex3f(a,-a,-a);
	glNormal3f(-1,-1,-1); glVertex3f(-a,-a,-a);
	//

	glEnd();
}

void __fastcall TForm1::Oswietlenie()
{
   MlecznaZarowka();
   ZoltaIZielonaMleczneZarowki();
   Reflektor();
}

void __fastcall TForm1::MlecznaZarowka()
{
   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT1);
}

void __fastcall TForm1::ZoltaIZielonaMleczneZarowki()
{
   //zolta mleczna zarowka
	const float kolor_rozproszone_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_rozproszone_zolta);
	glEnable(GL_LIGHT2);

   //zielona mleczna zarowka
	const float kolor_rozproszone_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};

	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_rozproszone_zielony);
	glEnable(GL_LIGHT3);
}

void __fastcall TForm1::Reflektor()
{
   const float kolor_rozproszone[4]={0.3,0.3,0.3,1.0};
   const float kolor_reflektora[4]={1.0,1.0,1.0,1.0};
   const float pozycja[4]={0.0,-10.0,10.0,1.0};
   const szerokosc_wiazki=60.0; //w stopniach
   glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
   glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);
   glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_reflektora);
   glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
   glEnable(GL_LIGHT4);
}

